# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 3
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR3_strategy.txt
# LLM Suggested Fallback: D

def sunshine_ally(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"  # Start with cooperation to build trust
    
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Check if opponent is an always-defector
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Check if opponent defected 3+ times in a row
    if len(opp_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
        return "D"
    
    # Initial phase: Cooperate in rounds 1-3
    if current_round <= 3:
        return "C"
    
    # Middle phase: Opportunistic defection in rounds 4-7
    if 4 <= current_round <= 7:
        # Defect after 2-3 mutual cooperations
        if len(my_history) >= 2 and all(m == "C" for m in my_history[-2:]) and all(o == "C" for o in opp_history[-2:]):
            return "D"
        # Avoid consecutive defections
        if len(my_history) >= 1 and my_history[-1] == "D":
            return "C"
        # Default to cooperation
        return "C"
    
    # Late phase: Defect in last 2 rounds if opponent has been cooperative
    if current_round >= total_rounds - 1:
        if sum(1 for o in opp_history if o == "D") <= 2:  # Opponent mostly cooperated
            return "D"
        else:
            return "C"
    
    # Default to cooperation if none of the above conditions apply
    return "C"